/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1999 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "AdpClient.h"

#include "AdpClientDoc.h"
#include "AdpClientView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView

IMPLEMENT_DYNCREATE(CAdpClientView, CView)

BEGIN_MESSAGE_MAP(CAdpClientView, CView)
	//{{AFX_MSG_MAP(CAdpClientView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView construction/destruction

CAdpClientView::CAdpClientView()
{
	// TODO: add construction code here

}

CAdpClientView::~CAdpClientView()
{
}

BOOL CAdpClientView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView drawing

void CAdpClientView::OnDraw(CDC* pDC)
{
	CAdpClientDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView printing

BOOL CAdpClientView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CAdpClientView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CAdpClientView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView diagnostics

#ifdef _DEBUG
void CAdpClientView::AssertValid() const
{
	CView::AssertValid();
}

void CAdpClientView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAdpClientDoc* CAdpClientView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAdpClientDoc)));
	return (CAdpClientDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAdpClientView message handlers

void CAdpClientView::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	CRect rect;
	GetClientRect(rect);
	int right = rect.right;
	int bottom = rect.bottom;

	CBitmap bitmap;
	bitmap.LoadBitmap(IDB_BITMAP1);

	BITMAP bmp;
	bitmap.GetBitmap(&bmp);

	CDC memDC;
	memDC.CreateCompatibleDC(&dc);
	CBitmap *oldBitmap = memDC.SelectObject(&bitmap);

	int xSrc = (right - bmp.bmWidth)/2;
	int ySrc = (bottom - bmp.bmHeight)/2;
	dc.BitBlt(xSrc,ySrc, bmp.bmWidth, bmp.bmHeight, &memDC, 0, 0,MERGECOPY);
	memDC.SelectObject(oldBitmap);

}
